﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;

namespace PI.ZB.N1200.ELearning.WebApplication.Accounts
{
    public partial class Administration : BaseComponent
    {
        protected class ClassEditNotePanel : ClassEditBasePanel
        {
            public ClassEditNotePanel(Administration Component) : base(Component) { }

            public override void Load()
            {
                base.Load();
                if (Class != null && Component.Instructor != null)
                {
                    List<BL.BO.View.EvaluationSheet> _listEvaluationSheetView = Component.BLELearning.EvaluationSheet.View.Restore(Class);
                    Component.XML.Element.Start("EvaluationSheet_ClassList");
                    foreach (BL.BO.View.EvaluationSheet _evaluationSheetView in _listEvaluationSheetView)
                    {
                        Component.XML.Element.Start("EvaluationSheet_Class");
                        Component.XML.Element.Attribute("From", _evaluationSheetView.From);
                        Component.XML.Element.Attribute("ID", _evaluationSheetView.ID);
                        Component.XML.Element.Attribute("To", _evaluationSheetView.To);
                        Component.XML.Element.Attribute("Value", _evaluationSheetView.Name);
                        Component.XML.Element.Attribute("Abbreviation", _evaluationSheetView.Abbreviation);
                        Component.XML.Element.Attribute("EvaluationSheetID", _evaluationSheetView.EvaluationSheetID);
                        Component.XML.Element.End();
                    }
                    Component.XML.Element.End();

                }
            }

            public override bool Save()
            {
                Component.MethodResult.SetSuccess = base.Save();

                if(Component.MethodResult.Success)
                {
                    if (Component.Instructor != null)
                    {
                        switch (EditMode)
                        {
                            case EditModeType.EditOrInsert:
                                try
                                {
                                    List<BL.BO.EvaluationSheet_Class> _listEvaluationSheet_Class = Component.BLELearning.EvaluationSheet.Class.Restore(Class);
                                    if (_listEvaluationSheet_Class != null)
                                    {
                                        try
                                        {
                                            foreach (BL.BO.EvaluationSheet_Class _evaluationSheet_Class in _listEvaluationSheet_Class)
                                            {
                                                int? _from = Component.Environment.GetRequestParamInt("txt_from_ES_Class_" + _evaluationSheet_Class.EvaluationSheetID);
                                                int? _to = Component.Environment.GetRequestParamInt("txt_to_ES_Class_" + _evaluationSheet_Class.EvaluationSheetID);

                                                if (_from.HasValue && _to.HasValue)
                                                {
                                                    _evaluationSheet_Class.From = _from;
                                                    _evaluationSheet_Class.To = _to;

                                                    Component.MethodResult.Add(Component.BLELearning.EvaluationSheet.Class.Save(_evaluationSheet_Class));
                                                }
                                            }
                                        }
                                        catch { }
                                    }
                                }
                                catch (Exception _exception)
                                {
                                    Component.MethodResult.Add(_exception);
                                    return false;
                                }
                                break;
                            case EditModeType.Remove:
                                break;
                        }
                    }
                }
                return Component.MethodResult.Success;
            }
        }
    }
}